/*
 * jQuery File Upload Plugin 5.0.2
 * https://github.com/blueimp/jQuery-File-Upload
 *
 * Copyright 2010, Sebastian Tschan
 * https://blueimp.net
 *
 * Licensed under the MIT license:
 * http://creativecommons.org/licenses/MIT/
 */

/*jslint nomen: true, unparam: true, regexp: true */
/*global document, XMLHttpRequestUpload, Blob, File, FormData, location, jQuery */
(function(a){"use strict";a.widget("blueimp.fileupload",{options:{namespace:undefined,dropZone:a(document),fileInput:undefined,replaceFileInput:true,paramName:undefined,singleFileUploads:true,sequentialUploads:false,forceIframeTransport:false,multipart:true,maxChunkSize:undefined,uploadedBytes:undefined,recalculateProgress:true,formData:function(a){return a.serializeArray()},add:function(a,b){b.submit()},processData:false,contentType:false,cache:false},_refreshOptionsList:["namespace","dropZone","fileInput"],_isXHRUpload:function(a){var b="undefined";return!a.forceIframeTransport&&typeof XMLHttpRequestUpload!==b&&typeof File!==b&&(!a.multipart||typeof FormData!==b)},_getFormData:function(b){var c;if(typeof b.formData==="function"){return b.formData(b.form)}else if(a.isArray(b.formData)){return b.formData}else if(b.formData){c=[];a.each(b.formData,function(a,b){c.push({name:a,value:b})});return c}return[]},_getTotal:function(b){var c=0;a.each(b,function(a,b){c+=b.size||1});return c},_onProgress:function(a,b){if(a.lengthComputable){var c=b.total||this._getTotal(b.files),d=parseInt(a.loaded/a.total*(b.chunkSize||c),10)+(b.uploadedBytes||0);this._loaded+=d-(b.loaded||b.uploadedBytes||0);b.lengthComputable=true;b.loaded=d;b.total=c;this._trigger("progress",a,b);this._trigger("progressall",a,{lengthComputable:true,loaded:this._loaded,total:this._total})}},_initProgressListener:function(b){var c=this,d=b.xhr?b.xhr():a.ajaxSettings.xhr();if(d.upload&&d.upload.addEventListener){d.upload.addEventListener("progress",function(a){c._onProgress(a,b)},false);b.xhr=function(){return d}}},_initXHRData:function(b){var c,d=b.files[0];if(!b.multipart||b.blob){b.headers=a.extend(b.headers,{"X-File-Name":d.name,"X-File-Type":d.type,"X-File-Size":d.size});if(!b.blob){b.contentType=d.type;b.data=d}else if(!b.multipart){b.contentType="application/octet-stream";b.data=b.blob}}if(b.multipart&&typeof FormData!=="undefined"){if(b.formData instanceof FormData){c=b.formData}else{c=new FormData;a.each(this._getFormData(b),function(a,b){c.append(b.name,b.value)})}if(b.blob){c.append(b.paramName,b.blob)}else{a.each(b.files,function(a,d){if(d instanceof Blob){c.append(b.paramName,d)}})}b.data=c}b.blob=null},_initIframeSettings:function(a){a.dataType="iframe "+(a.dataType||"");a.formData=this._getFormData(a)},_initDataSettings:function(a){if(this._isXHRUpload(a)){if(!this._chunkedUpload(a,true)){if(!a.data){this._initXHRData(a)}this._initProgressListener(a)}}else{this._initIframeSettings(a)}},_initFormSettings:function(b){if(!b.form||!b.form.length){b.form=a(b.fileInput.prop("form"))}if(!b.paramName){b.paramName=b.fileInput.prop("name")||"files[]"}if(!b.url){b.url=b.form.prop("action")||location.href}b.type=(b.type||b.form.prop("method")||"").toUpperCase();if(b.type!=="POST"&&b.type!=="PUT"){b.type="POST"}},_getAJAXSettings:function(b){var c=a.extend({},this.options,b);this._initFormSettings(c);this._initDataSettings(c);return c},_enhancePromise:function(a){a.success=a.done;a.error=a.fail;a.complete=a.always;return a},_getXHRPromise:function(b,c,d){var e=a.Deferred(),f=e.promise();c=c||this.options.context||f;if(b===true){e.resolveWith(c,d)}else if(b===false){e.rejectWith(c,d)}f.abort=e.promise;return this._enhancePromise(f)},_chunkedUpload:function(b,c){var d=this,e=b.files[0],f=e.size,g=b.uploadedBytes=b.uploadedBytes||0,h=b.maxChunkSize||f,i=e.webkitSlice||e.mozSlice||e.slice,j,k,l,m;if(!(this._isXHRUpload(b)&&i&&(g||h<f))||b.data){return false}if(c){return true}if(g>=f){e.error="uploadedBytes";return this._getXHRPromise(false)}k=Math.ceil((f-g)/h);j=function(c){if(!c){return d._getXHRPromise(true)}return j(c-=1).pipe(function(){var f=a.extend({},b);f.blob=i.call(e,g+c*h,g+(c+1)*h);f.chunkSize=f.blob.size;d._initXHRData(f);d._initProgressListener(f);l=(a.ajax(f)||d._getXHRPromise(false,f.context)).done(function(){if(!f.loaded){d._onProgress(a.Event("progress",{lengthComputable:true,loaded:f.chunkSize,total:f.chunkSize}),f)}b.uploadedBytes=f.uploadedBytes+=f.chunkSize});return l})};m=j(k);m.abort=function(){return l.abort()};return this._enhancePromise(m)},_beforeSend:function(a,b){if(this._active===0){this._trigger("start")}this._active+=1;this._loaded+=b.uploadedBytes||0;this._total+=this._getTotal(b.files)},_onDone:function(b,c,d,e){if(!this._isXHRUpload(e)){this._onProgress(a.Event("progress",{lengthComputable:true,loaded:1,total:1}),e)}e.result=b;e.textStatus=c;e.jqXHR=d;this._trigger("done",null,e)},_onFail:function(a,b,c,d){d.jqXHR=a;d.textStatus=b;d.errorThrown=c;this._trigger("fail",null,d);if(d.recalculateProgress){this._loaded-=d.loaded||d.uploadedBytes||0;this._total-=d.total||this._getTotal(d.files)}},_onAlways:function(a,b,c,d,e){this._active-=1;e.result=a;e.textStatus=b;e.jqXHR=c;e.errorThrown=d;this._trigger("always",null,e);if(this._active===0){this._trigger("stop");this._loaded=this._total=0}},_onSend:function(b,c){var d=this,e,f,g=d._getAJAXSettings(c),h=function(c,f){e=e||(c!==false&&d._trigger("send",b,g)!==false&&(d._chunkedUpload(g)||a.ajax(g))||d._getXHRPromise(false,g.context,f)).done(function(a,b,c){d._onDone(a,b,c,g)}).fail(function(a,b,c){d._onFail(a,b,c,g)}).always(function(a,b,c){if(!c||typeof c==="string"){d._onAlways(undefined,b,a,c,g)}else{d._onAlways(a,b,c,undefined,g)}});return e};this._beforeSend(b,g);if(this.options.sequentialUploads){f=this._sequence=this._sequence.pipe(h,h);f.abort=function(){if(!e){return h(false,[undefined,"abort","abort"])}return e.abort()};return this._enhancePromise(f)}return h()},_onAdd:function(b,c){var d=this,e=true,f=a.extend({},this.options,c);if(f.singleFileUploads&&this._isXHRUpload(f)){a.each(c.files,function(f,g){var h=a.extend({},c,{files:[g]});h.submit=function(){return d._onSend(b,h)};return e=d._trigger("add",b,h)});return e}else if(c.files.length){c=a.extend({},c);c.submit=function(){return d._onSend(b,c)};return this._trigger("add",b,c)}},_normalizeFile:function(a,b){if(b.name===undefined&&b.size===undefined){b.name=b.fileName;b.size=b.fileSize}},_replaceFileInput:function(b){var c=b.clone(true);a("<form></form>").append(c)[0].reset();b.after(c).detach();this.options.fileInput=this.options.fileInput.map(function(a,d){if(d===b[0]){return c[0]}return d})},_onChange:function(b){var c=b.data.fileupload,d={files:a.each(a.makeArray(b.target.files),c._normalizeFile),fileInput:a(b.target),form:a(b.target.form)};if(!d.files.length){d.files=[{name:b.target.value.replace(/^.*\\/,"")}]}if(d.form.length){d.fileInput.data("blueimp.fileupload.form",d.form)}else{d.form=d.fileInput.data("blueimp.fileupload.form")}if(c.options.replaceFileInput){c._replaceFileInput(d.fileInput)}if(c._trigger("change",b,d)===false||c._onAdd(b,d)===false){return false}},_onDrop:function(b){var c=b.data.fileupload,d=b.dataTransfer=b.originalEvent.dataTransfer,e={files:a.each(a.makeArray(d&&d.files),c._normalizeFile)};if(c._trigger("drop",b,e)===false||c._onAdd(b,e)===false){return false}b.preventDefault()},_onDragOver:function(a){var b=a.data.fileupload,c=a.dataTransfer=a.originalEvent.dataTransfer;if(b._trigger("dragover",a)===false){return false}if(c){c.dropEffect=c.effectAllowed="copy"}a.preventDefault()},_initEventHandlers:function(){var a=this.options.namespace||this.name;this.options.dropZone.bind("dragover."+a,{fileupload:this},this._onDragOver).bind("drop."+a,{fileupload:this},this._onDrop);this.options.fileInput.bind("change."+a,{fileupload:this},this._onChange)},_destroyEventHandlers:function(){var a=this.options.namespace||this.name;this.options.dropZone.unbind("dragover."+a,this._onDragOver).unbind("drop."+a,this._onDrop);this.options.fileInput.unbind("change."+a,this._onChange)},_beforeSetOption:function(a,b){this._destroyEventHandlers()},_afterSetOption:function(b,c){var d=this.options;if(!d.fileInput){d.fileInput=a()}if(!d.dropZone){d.dropZone=a()}this._initEventHandlers()},_setOption:function(b,c){var d=a.inArray(b,this._refreshOptionsList)!==-1;if(d){this._beforeSetOption(b,c)}a.Widget.prototype._setOption.call(this,b,c);if(d){this._afterSetOption(b,c)}},_create:function(){var b=this.options;if(b.fileInput===undefined){b.fileInput=this.element.is("input:file")?this.element:this.element.find("input:file")}else if(!b.fileInput){b.fileInput=a()}if(!b.dropZone){b.dropZone=a()}this._sequence=this._getXHRPromise(true);this._active=this._loaded=this._total=0;this._initEventHandlers()},destroy:function(){this._destroyEventHandlers();a.Widget.prototype.destroy.call(this)},enable:function(){a.Widget.prototype.enable.call(this);this._initEventHandlers()},disable:function(){this._destroyEventHandlers();a.Widget.prototype.disable.call(this)},add:function(b){if(!b||this.options.disabled){return}b.files=a.each(a.makeArray(b.files),this._normalizeFile);this._onAdd(null,b)},send:function(b){if(b&&!this.options.disabled){b.files=a.each(a.makeArray(b.files),this._normalizeFile);if(b.files.length){return this._onSend(null,b)}}return this._getXHRPromise(false,b&&b.context)}})})(jQuery)