/*
 * jQuery File Upload User Interface Plugin 5.0.13
 * https://github.com/blueimp/jQuery-File-Upload
 *
 * Copyright 2010, Sebastian Tschan
 * https://blueimp.net
 *
 * Licensed under the MIT license:
 * http://creativecommons.org/licenses/MIT/
 */

/*jslint nomen: true, unparam: true, regexp: true */
/*global window, document, URL, webkitURL, FileReader, jQuery */
(function(a){"use strict";a.widget("blueimpUI.fileupload",a.blueimp.fileupload,{options:{autoUpload:false,maxNumberOfFiles:undefined,maxFileSize:undefined,minFileSize:1,acceptFileTypes:/.+$/i,previewFileTypes:/^image\/(gif|jpeg|png)$/,previewMaxWidth:80,previewMaxHeight:80,previewAsCanvas:true,uploadTemplate:a("#template-upload"),downloadTemplate:a("#template-download"),dataType:"json",add:function(b,c){var d=a(this).data("fileupload");d._adjustMaxNumberOfFiles(-c.files.length);c.isAdjusted=true;c.isValidated=d._validate(c.files);c.context=d._renderUpload(c.files).appendTo(a(this).find(".files")).fadeIn(function(){a(this).show()}).data("data",c);if((d.options.autoUpload||c.autoUpload)&&c.isValidated){c.jqXHR=c.submit()}},send:function(b,c){if(!c.isValidated){var d=a(this).data("fileupload");if(!c.isAdjusted){d._adjustMaxNumberOfFiles(-c.files.length)}if(!d._validate(c.files)){return false}}if(c.context&&c.dataType&&c.dataType.substr(0,6)==="iframe"){c.context.find(".ui-progressbar").progressbar("value",parseInt(100,10))}},done:function(b,c){var d=a(this).data("fileupload");if(c.context){c.context.each(function(b){var e=a.isArray(c.result)&&c.result[b]||{error:"emptyResult"};if(e.error){d._adjustMaxNumberOfFiles(1)}else{var f=a("#upload-dialog").data("editorId");var g=a("#"+f).closest("form").attr("id");a('<input type="hidden" name="filedataids[]" />').val(c.result[b].filedataid).data("url",c.result[b].url).data("thumbnail_url",c.result[b].thumbnail_url).data("name",c.result[b].name).appendTo("#"+g);a('<input type="hidden" name="filename_'+c.result[b].filedataid+'" />').val(c.result[b].name).data("name",c.result[b].name).appendTo("#"+g)}a(this).fadeOut(function(){d._renderDownload([e]).css("display","none").replaceAll(this).fadeIn(function(){a(this).show()})})})}else{d._renderDownload(c.result).css("display","none").appendTo(a(this).find(".files")).fadeIn(function(){a(this).show()})}},fail:function(b,c){var d=a(this).data("fileupload");d._adjustMaxNumberOfFiles(c.files.length);if(c.context){c.context.each(function(b){a(this).fadeOut(function(){if(c.errorThrown!=="abort"){var e=c.files[b];e.error=e.error||c.errorThrown||true;d._renderDownload([e]).css("display","none").replaceAll(this).fadeIn(function(){a(this).show()})}else{c.context.remove()}})})}else if(c.errorThrown!=="abort"){d._adjustMaxNumberOfFiles(-c.files.length);c.context=d._renderUpload(c.files).css("display","none").appendTo(a(this).find(".files")).fadeIn(function(){a(this).show()}).data("data",c)}},progress:function(a,b){if(b.context){b.context.find(".ui-progressbar").progressbar("value",parseInt(b.loaded/b.total*100,10))}},progressall:function(b,c){a(this).find(".fileupload-progressbar").progressbar("value",parseInt(c.loaded/c.total*100,10))},start:function(){a(this).find(".fileupload-progressbar").progressbar("value",0).fadeIn()},stop:function(){a(this).find(".fileupload-progressbar").fadeOut()},destroy:function(b,c){var d=a(this).data("fileupload");if(c.url){a.ajax(c).success(function(){d._adjustMaxNumberOfFiles(1);a(this).fadeOut(function(){a(this).remove()})})}else{c.context.fadeOut(function(){a(this).remove()})}}},_scaleImage:function(a,b){b=b||{};var c=document.createElement("canvas"),d=Math.min((b.maxWidth||a.width)/a.width,(b.maxHeight||a.height)/a.height);if(d>=1){d=Math.max((b.minWidth||a.width)/a.width,(b.minHeight||a.height)/a.height)}a.width=parseInt(a.width*d,10);a.height=parseInt(a.height*d,10);if(!b.canvas||!c.getContext){return a}c.width=a.width;c.height=a.height;c.getContext("2d").drawImage(a,0,0,a.width,a.height);return c},_createObjectURL:function(a){var b="undefined",c=typeof window.createObjectURL!==b&&window||typeof URL!==b&&URL||typeof webkitURL!==b&&webkitURL;return c?c.createObjectURL(a):false},_revokeObjectURL:function(a){var b="undefined",c=typeof window.revokeObjectURL!==b&&window||typeof URL!==b&&URL||typeof webkitURL!==b&&webkitURL;return c?c.revokeObjectURL(a):false},_loadFile:function(a,b){if(typeof FileReader!=="undefined"&&FileReader.prototype.readAsDataURL){var c=new FileReader;c.onload=function(a){b(a.target.result)};c.readAsDataURL(a);return true}return false},_loadImage:function(b,c,d){var e=this,f,g;if(!d||!d.fileTypes||d.fileTypes.test(b.type)){f=this._createObjectURL(b);g=a("<img>").bind("load",function(){a(this).unbind("load");e._revokeObjectURL(f);c(e._scaleImage(g[0],d))}).prop("src",f);if(!f){this._loadFile(b,function(a){g.prop("src",a)})}}},_enableDragToDesktop:function(){var b=a(this),c=b.prop("href"),d=decodeURIComponent(c.split("/").pop()).replace(/:/g,"-"),e="application/octet-stream";b.bind("dragstart",function(a){try{a.originalEvent.dataTransfer.setData("DownloadURL",[e,d,c].join(":"))}catch(b){}})},_adjustMaxNumberOfFiles:function(a){if(typeof this.options.maxNumberOfFiles==="number"){this.options.maxNumberOfFiles+=a;if(this.options.maxNumberOfFiles<1){this._disableFileInputButton()}else{this._enableFileInputButton()}}},_formatFileSize:function(a){if(typeof a.size!=="number"){return""}if(a.size>=1e9){return(a.size/1e9).toFixed(2)+" GB"}if(a.size>=1e6){return(a.size/1e6).toFixed(2)+" MB"}return(a.size/1e3).toFixed(2)+" KB"},_hasError:function(a){if(a.error){return a.error}if(this.options.maxNumberOfFiles<0){return"maxNumberOfFiles"}if(!(this.options.acceptFileTypes.test(a.type)||this.options.acceptFileTypes.test(a.name))){return"acceptFileTypes"}if(this.options.maxFileSize&&a.size>this.options.maxFileSize){return"maxFileSize"}if(typeof a.size==="number"&&a.size<this.options.minFileSize){return"minFileSize"}return null},_validate:function(b){var c=this,d;a.each(b,function(a,b){b.error=c._hasError(b);d=!b.error});return d},_uploadTemplateHelper:function(a){a.sizef=this._formatFileSize(a);return a},_renderUploadTemplate:function(b){var c=this;return a.tmpl(this.options.uploadTemplate,a.map(b,function(a){return c._uploadTemplateHelper(a)}))},_renderUpload:function(b){var c=this,d=this.options,e=this._renderUploadTemplate(b);if(!(e instanceof a)){return a()}e.css("display","none");e.find(".progress div").slice(1).remove().end().first().progressbar();e.find(".start button").slice(this.options.autoUpload?0:1).remove().end().first().button({text:false,icons:{primary:"ui-icon-circle-arrow-e"}});e.find(".cancel button").slice(1).remove().end().first().button({text:false,icons:{primary:"ui-icon-cancel"}});e.find(".preview").each(function(e,f){c._loadImage(b[e],function(b){a(b).hide().appendTo(f).fadeIn()},{maxWidth:d.previewMaxWidth,maxHeight:d.previewMaxHeight,fileTypes:d.previewFileTypes,canvas:d.previewAsCanvas})});return e},_downloadTemplateHelper:function(a){a.sizef=this._formatFileSize(a);return a},_renderDownloadTemplate:function(b){var c=this;return a.tmpl(this.options.downloadTemplate,a.map(b,function(a){return c._downloadTemplateHelper(a)}))},_renderDownload:function(b){var c=this._renderDownloadTemplate(b);if(!(c instanceof a)){return a()}c.css("display","none");c.find(".delete button").button({text:false,icons:{primary:"ui-icon-trash"}});c.find("a").each(this._enableDragToDesktop);return c},_startHandler:function(b){b.preventDefault();var c=a(this).closest(".template-upload"),d=c.data("data");if(d&&d.submit&&!d.jqXHR){d.jqXHR=d.submit();a(this).fadeOut()}},_cancelHandler:function(b){b.preventDefault();var c=a(this).closest(".template-upload"),d=c.data("data")||{};if(!d.jqXHR){d.errorThrown="abort";b.data.fileupload._trigger("fail",b,d)}else{d.jqXHR.abort()}},_deleteHandler:function(b){b.preventDefault();var c=a(this);b.data.fileupload._trigger("destroy",b,{context:c.closest(".template-download"),url:c.attr("data-url"),type:c.attr("data-type"),dataType:b.data.fileupload.options.dataType})},_initEventHandlers:function(){a.blueimp.fileupload.prototype._initEventHandlers.call(this);var b=this.element.find(".files"),c={fileupload:this};b.find(".start button").live("click."+this.options.namespace,c,this._startHandler);b.find(".cancel button").live("click."+this.options.namespace,c,this._cancelHandler);b.find(".delete button").live("click."+this.options.namespace,c,this._deleteHandler)},_destroyEventHandlers:function(){var b=this.element.find(".files");b.find(".start button").die("click."+this.options.namespace);b.find(".cancel button").die("click."+this.options.namespace);b.find(".delete button").die("click."+this.options.namespace);a.blueimp.fileupload.prototype._destroyEventHandlers.call(this)},_initFileUploadButtonBar:function(){var b=this.element.find(".fileupload-buttonbar"),c=this.element.find(".files"),d=this.options.namespace;b.addClass("ui-widget-header ui-corner-top");this.element.find(".fileinput-button").each(function(){var b=a(this).find("input:file").detach();a(this).button({icons:{primary:"ui-icon-plusthick"}}).append(b)});b.find(".start").button({icons:{primary:"ui-icon-circle-arrow-e"}}).bind("click."+d,function(a){a.preventDefault();c.find(".start button").click()});b.find(".cancel").button({icons:{primary:"ui-icon-cancel"}}).bind("click."+d,function(a){a.preventDefault();c.find(".cancel button").click()});b.find(".delete").button({icons:{primary:"ui-icon-trash"}}).bind("click."+d,function(a){a.preventDefault();c.find(".delete button").click()})},_destroyFileUploadButtonBar:function(){this.element.find(".fileupload-buttonbar").removeClass("ui-widget-header ui-corner-top");this.element.find(".fileinput-button").each(function(){var b=a(this).find("input:file").detach();a(this).button("destroy").append(b)});this.element.find(".fileupload-buttonbar button").unbind("click."+this.options.namespace).button("destroy")},_enableFileInputButton:function(){this.element.find(".fileinput-button input:file:disabled").each(function(){var b=a(this),c=b.parent();b.detach().prop("disabled",false);c.button("enable").append(b)})},_disableFileInputButton:function(){this.element.find(".fileinput-button input:file:enabled").each(function(){var b=a(this),c=b.parent();b.detach().prop("disabled",true);c.button("disable").append(b)})},_initTemplates:function(){if(this.options.uploadTemplate instanceof a&&!this.options.uploadTemplate.length){this.options.uploadTemplate=a(this.options.uploadTemplate.selector)}if(this.options.downloadTemplate instanceof a&&!this.options.downloadTemplate.length){this.options.downloadTemplate=a(this.options.downloadTemplate.selector)}},_create:function(){a.blueimp.fileupload.prototype._create.call(this);this._initTemplates();this.element.addClass("ui-widget");this._initFileUploadButtonBar();this.element.find(".fileupload-content").addClass("ui-widget-content ui-corner-bottom");this.element.find(".fileupload-progressbar").hide().progressbar()},destroy:function(){this.element.find(".fileupload-progressbar").progressbar("destroy");this.element.find(".fileupload-content").removeClass("ui-widget-content ui-corner-bottom");this._destroyFileUploadButtonBar();this.element.removeClass("ui-widget");a.blueimp.fileupload.prototype.destroy.call(this)},enable:function(){a.blueimp.fileupload.prototype.enable.call(this);this.element.find(":ui-button").not(".fileinput-button").button("enable");this._enableFileInputButton()},disable:function(){this.element.find(":ui-button").not(".fileinput-button").button("disable");this._disableFileInputButton();a.blueimp.fileupload.prototype.disable.call(this)}})})(jQuery)