<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.1.9 Patch Level 4 - Licence Number LD125EAAF9
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2016 vBulletin Solutions Inc. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB5_Template_Stylevar
{

	protected static $instance;
	protected $cache = array();
	protected $stylePreference = array();

	/**
	 *
	 * @return vB5_Template_Stylevar
	 */
	public static function instance()
	{
		if (!isset(self::$instance))
		{
			$c = __CLASS__;
			self::$instance = new $c;
		}

		return self::$instance;
	}

	protected function __construct()
	{
		$this->getStylePreference();
		$this->fetchStyleVars();
	}

	/**
	 * Returns the styleid that should be used on this request
	 */
	public function getPreferredStyleId()
	{
		return intval(reset($this->stylePreference));
	}

	/**
	 * Gets the styles to be used ordered by preference
	 */
	protected function getStylePreference()
	{
		$this->stylePreference = array();

		try
		{
			$router = vB5_ApplicationAbstract::instance()->getRouter();
			if (!empty($router))
			{
				$arguments = $router->getArguments();

				// #1 check for a forced style in current route
				if (!empty($arguments) AND !empty($arguments['forceStyleId']) AND intval($arguments['forceStyleId']))
				{
					$this->stylePreference[] = $arguments['forceStyleId'];
				}
			}
		}
		catch (vB5_Exception $e)
		{
			// the application instance might not be initialized yet, so just ignore this first check
		}

		// #2 check for a style cookie (style chooser in footer)
		// If style is set in querystring, the routing component will set this cookie (VBV-3322)
		$cookieStyleId = vB5_Cookie::get('userstyleid', vB5_Cookie::TYPE_UINT);
		if (!empty($cookieStyleId))
		{
			$this->stylePreference[] = $cookieStyleId;
		}

		// #3 check for user defined style
		$userStyleId = vB5_User::get('styleid');
		if (!empty($userStyleId))
		{
			$this->stylePreference[] = $userStyleId;
		}

		// #4 check for a route style which is not forced
		if (!empty($arguments) AND isset($arguments['routeStyleId']) AND is_int($arguments['routeStyleId']))
		{
			$this->stylePreference[] = $arguments['routeStyleId'];
		}

		// #5 check for the overall site default style
		$defaultStyleId = vB5_Template_Options::instance()->get('options.styleid');
		if ($defaultStyleId)
		{
			$this->stylePreference[] = $defaultStyleId;
		}

		// Moved from Api_Interface_Collapsed::init, it was calling getPreferredStyleId when the forced
		// style set by the route wasn't ready yet. (see VBV-3324)
		if (!empty($this->stylePreference[0]))
		{
			// If style is -1 then fetch site default styleid
			if ($this->stylePreference[0] == '-1')
			{
				$this->stylePreference[0] = $defaultStyleId;
			}
			vB::getCurrentSession()->set('styleid', $this->stylePreference[0]);
		}

	}

	public function get($name)
	{
		$path = explode('.', $name);

		$var = $this->cache;
		foreach ($path as $t)
		{
			if (isset($var[$t]))
			{
				$var = $var[$t];
			}
			else
			{
				return NULL;
			}
		}

		return $var;
	}

	protected function fetchStyleVars()
	{
		$res = Api_InterfaceAbstract::instance()->callApi('style', 'fetchStyleVars', array($this->stylePreference)); // api method returns unserealized stylevars

		if (empty($res) OR !empty($res['errors']))
		{
			return;
		}

		$user = vB5_User::instance();
		if (is_null($user['lang_options']) OR (isset($user['lang_options']) AND is_array($user['lang_options']) AND !empty($user['lang_options']['direction'])))
		{
			// if user has a LTR language selected
			$res['textdirection'] = array('datatype' => 'string', 'string' => 'ltr');
			$res['left'] = array('datatype' => 'string', 'string' => 'left');
			$res['right'] = array('datatype' => 'string', 'string' => 'right');
		}
		else
		{
			// if user has a RTL language selected
			$res['textdirection'] = array('datatype' => 'string', 'string' => 'rtl');
			$res['left'] = array('datatype' => 'string', 'string' => 'right');
			$res['right'] = array('datatype' => 'string', 'string' => 'left');
		}

		foreach ($res as $key => $value)
		{
			$this->cache[$key] = $value;
		}
	}

}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 05:43, Thu May 26th 2016
|| # CVS: $RCSfile$ - $Revision: 83435 $
|| #######################################################################
\*=========================================================================*/
