#!/usr/local/bin/php -q
<?php

/*
Set $myforumroot to the absolute path to your forum directory.
Example:
$myforumroot = '/home/username/public_html';
*/
$myforumroot = '/path/to/forum/root';

/*########## DO NOT TOUCH ANYTHING BELOW THIS LINE ##########*/
ob_start();
chdir($myforumroot);
require_once('./config.php');
require_once($config['core_path'] . '/includes/config.php');
print "
source {$config['Database']['dbname']}_disk
{
	type			= mysql
	sql_host		= {$config['MasterServer']['servername']}
	sql_user		= {$config['MasterServer']['username']}
	sql_pass		= {$config['MasterServer']['password']}
	sql_db			= {$config['Database']['dbname']}
	sql_port		= {$config['MasterServer']['port']}	# optional, default is 3306
	sql_query_pre		= CREATE TEMPORARY TABLE IF NOT EXISTS {$config['Database']['tableprefix']}temp_index ( \
					nodeid INT(11) NOT NULL DEFAULT 0,\
					caption TEXT, \
					PRIMARY KEY (nodeid) \
				)
	sql_query_pre		= INSERT INTO {$config['Database']['tableprefix']}temp_index SELECT n.parentid AS nodeid, GROUP_CONCAT(att.caption) AS caption FROM ( \
					(select a.nodeid, a.caption FROM {$config['Database']['tableprefix']}attach a) \
					union all \
					(select p.nodeid, p.caption FROM {$config['Database']['tableprefix']}photo p) \
				) AS att \
				JOIN {$config['Database']['tableprefix']}node n WHERE att.nodeid = n.nodeid \
				GROUP BY n.parentid
	sql_query_pre		= CREATE TEMPORARY TABLE IF NOT EXISTS {$config['Database']['tableprefix']}temp_poll ( \
					nodeid INT(11) NOT NULL DEFAULT 0,\
					question VARCHAR(100), \
					content TEXT, \
					PRIMARY KEY (nodeid)\
				)
	sql_query_pre		= INSERT INTO {$config['Database']['tableprefix']}temp_poll \
							SELECT n.nodeid, n.title, GROUP_CONCAT(po.title) AS content \
							FROM {$config['Database']['tableprefix']}poll o \
							LEFT JOIN {$config['Database']['tableprefix']}polloption po ON po.nodeid = o.nodeid \
							INNER JOIN {$config['Database']['tableprefix']}node n ON n.nodeid = o.nodeid \
							GROUP BY po.nodeid

	sql_query_pre		= CREATE TEMPORARY TABLE IF NOT EXISTS {$config['Database']['tableprefix']}temp_depth ( \
					nodeid INT(11) NOT NULL DEFAULT 0,\
					depth TEXT, \
					PRIMARY KEY (nodeid)\
				)
	sql_query_pre		= INSERT INTO {$config['Database']['tableprefix']}temp_depth SELECT child, CONCAT('{', GROUP_CONCAT('\"n', parent, '\":', depth), '}') AS depth FROM {$config['Database']['tableprefix']}closure GROUP BY child

	sql_query		= \
	SELECT n.nodeid, n.title, \
				CONCAT( \
					ifnull(t.rawtext, ''), ' ', \
					ifnull(n.description, ''), ' ', \
					ifnull(a.caption, ''), ' ', \
					ifnull(a.filename, ' '), \
					ifnull(i.note, ' '), \
					ifnull(i.actionreason, ' '), \
					ifnull(i.customreason, ' '), \
					ifnull(l.url_title, ' '), \
					ifnull(p.caption, ' '), \
					ifnull(v.url_title, ' '), \
					ifnull(pl.question, ' '), \
					ifnull(pl.content, ' '), \
					ifnull(at.caption, ' ') \
				) AS content, \
				n.contenttypeid, n.lastcontentid, n.parentid, n.starter, n.userid, n.authorname, n.setfor, n.showpublished,\
				n.approved, n.showapproved, n.viewperms, n.featured, n.inlist, n.protected, n.votes, n.lastcontent, n.created, \
			 	n.publishdate, n.unpublishdate, crc32(n.prefixid) AS prefixid, n.textcount, \
				st.parentid AS starterparent, st.userid AS starteruser, d.depth AS depth \
			FROM {$config['Database']['tableprefix']}node AS n \
			LEFT JOIN {$config['Database']['tableprefix']}node st ON st.nodeid = n.nodeid \
			LEFT JOIN {$config['Database']['tableprefix']}text t ON t.nodeid = n.nodeid \
			LEFT JOIN {$config['Database']['tableprefix']}attach a ON a.nodeid = n.nodeid \
			LEFT JOIN {$config['Database']['tableprefix']}gallery g ON g.nodeid = n.nodeid \
			LEFT JOIN {$config['Database']['tableprefix']}infraction i ON i.nodeid = n.nodeid \
			LEFT JOIN {$config['Database']['tableprefix']}link l ON l.nodeid = n.nodeid \
			LEFT JOIN {$config['Database']['tableprefix']}photo p ON p.nodeid = n.nodeid \
			LEFT JOIN {$config['Database']['tableprefix']}video v ON v.nodeid = n.nodeid \
			LEFT JOIN {$config['Database']['tableprefix']}temp_poll AS pl ON pl.nodeid = n.nodeid \
			LEFT JOIN {$config['Database']['tableprefix']}temp_index AS at ON at.nodeid = n.nodeid \
			LEFT JOIN {$config['Database']['tableprefix']}temp_depth AS d ON d.nodeid = n.nodeid

	sql_attr_uint		= contenttypeid
	sql_attr_uint		= lastcontentid
	sql_attr_uint		= parentid
	sql_attr_uint		= starter
	sql_attr_uint		= starterparent
	sql_attr_uint		= starteruser
	sql_attr_multi		= uint closure from query; SELECT child, parent FROM {$config['Database']['tableprefix']}closure
	sql_attr_json		= depth
	sql_attr_uint		= userid
	sql_attr_string		= authorname
	sql_attr_uint		= setfor
	sql_attr_multi		= uint sentto from query; SELECT s.nodeid, s.userid FROM {$config['Database']['tableprefix']}sentto s WHERE deleted=0
	sql_attr_uint		= showpublished
	sql_attr_uint		= approved
	sql_attr_uint		= showapproved
	sql_attr_uint		= viewperms
	sql_attr_uint		= featured
	sql_attr_uint		= inlist
	sql_attr_uint		= protected
	sql_attr_uint		= votes
	sql_attr_timestamp	= lastcontent
	sql_attr_timestamp	= created
	sql_attr_timestamp	= publishdate
	sql_attr_timestamp	= unpublishdate
	sql_attr_uint		= prefixid
	sql_attr_multi		= uint tagid from query; SELECT tg.nodeid, tg.tagid tg FROM {$config['Database']['tableprefix']}tagnode tg
	sql_attr_uint		= textcount
}


index {$config['Database']['dbname']}_disk
{
	source			= {$config['Database']['dbname']}_disk
	path			= {$config['Misc']['sphinx_path']}/data/{$config['Database']['dbname']}_disk
	docinfo			= extern
	charset_type		= utf-8
}


index {$config['Database']['dbname']}
{
	type			= rt
	rt_mem_limit		= 256M

	path			= {$config['Misc']['sphinx_path']}/data/{$config['Database']['dbname']}
	charset_type		= utf-8

	rt_field		= title
	rt_field		= content
	rt_attr_uint		= contenttypeid
	rt_attr_uint		= lastcontentid
	rt_attr_uint		= parentid
	rt_attr_uint		= starter
	rt_attr_uint		= starterparent
	rt_attr_uint		= starteruser
	rt_attr_multi		= closure
	rt_attr_json		= depth
	rt_attr_uint		= userid
	rt_attr_string		= authorname
	rt_attr_uint		= setfor
	rt_attr_multi		= sentto
	rt_attr_uint		= showpublished
	rt_attr_uint		= approved
	rt_attr_uint		= showapproved
	rt_attr_uint		= viewperms
	rt_attr_uint		= featured
	rt_attr_uint		= inlist
	rt_attr_uint		= protected
	rt_attr_uint		= votes
	rt_attr_timestamp	= lastcontent
	rt_attr_timestamp	= created
	rt_attr_timestamp	= publishdate
	rt_attr_timestamp	= unpublishdate
	rt_attr_uint		= prefixid
	rt_attr_multi		= tagid
	rt_attr_uint		= textcount
}

indexer
{
	mem_limit		= 256M
}


searchd
{
	listen			= 9312
	listen			= {$config['Misc']['sphinx_port']}:mysql41
	log				= {$config['Misc']['sphinx_path']}/log/searchd.log
	read_timeout	= 5
	max_children	= 30
	pid_file		= {$config['Misc']['sphinx_path']}/log/searchd.pid
	max_matches		= 1000
	seamless_rotate	= 1
	preopen_indexes	= 1
	unlink_old		= 1
	workers			= threads # for RT to work
	binlog_path		= {$config['Misc']['sphinx_path']}/data
}";
?>
