<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<meta content="text/html; charset=windows-1252" http-equiv="Content-Type" />
	<meta http-equiv="MSThemeCompatible" content="yes" />
	<title>vBulletin Test Script</title>
	<link rel="stylesheet" href="http://images.vbulletin.com/testscript/vb_test.css" />
</head>
<body>
	<table cellpadding="4" cellspacing="0" border="0" width="100%" class="navbody">
		<tr valign="bottom">
			<td><img src="http://www.vbulletin.com/forum/core/cpstyles/vBulletin_5_Default/cp_logo.png" width="155" height="45" alt="cplogo" title="vBulletin &copy;2000-<?php echo date('Y'); ?> Jelsoft Enterprises Ltd." border="0" /></td>
			<td><b>vBulletin Server Test Script</b><br /><a href="http://www.vbulletin.com">vBulletin Website</a><br />&nbsp;</td>
		</tr>
	</table>
	<br />
	<table cellpadding="1" cellspacing="0" border="0" align="center" width="50%" class="tborder"><tr><td>
<table cellpadding="4" cellspacing="0" border="0" width="100%">
<?php
error_reporting(E_ALL);

function iif($condition, $truevalue, $falsevalue = '')
{
	if ($condition)
	{
		return $truevalue;
	}
	else
	{
		return $falsevalue;
	}
}

class DB
{
	public static function fetch_db($type, $host, $user, $password, $dbname)
	{
		global $db_connection_error;
		switch ($type)
		{
			case 'mysql':
				$obj = new mysql($host, $user, $password, $dbname);
				return ($obj->connection_resource ? $obj : false);
			case 'mysqli':
				$obj = @new mysqli($host, $user, $password, $dbname);
				if (mysqli_connect_errno())
				{
					$db_connection_error = mysqli_connect_error();
					return false;
				}
				return $obj;
		}
	}
}

class mysql
{
	var $connection_resource = NULL;

	function mysql($host = '127.0.0.1', $username = '', $password = '', $db = '')
	{
		global $db_connection_error;
		$this->connection_resource = @mysql_connect($host, $username, $password);
		if (!$this->connection_resource)
		{
			$db_connection_error = mysql_error();
		}
		@mysql_select_db($db, $this->connection_resource);
	}

	function query($statement)
	{
		$result = @mysql_query($statement, $this->connection_resource);
		if (is_resource($result))
		{
			return new mysql_result($result);
		}
		else
		{
			return $result;
		}
	}

	function close()
	{
		$result = @mysql_close($this->connection_resource);
		$this->connection_resource = NULL;
		return $result;
	}
}

class mysql_result
{
	var $result = NULL;
	function mysql_result($result)
	{
		$this->result = $result;
	}

	function fetch_array()
	{
		return @mysql_fetch_array($this->result);
	}
}

function test_ini_set($setting, $value)
{
	$result = @ini_set($setting, $value);
	if ($result === false OR $result === null)
	{
		return false;
	}
	else
	{
		return $result;
	}
}

//initalise variables dont want any XSS in our test script :)
$e_test = array();
$test = array();
$version = array();
$e_error = 0;
$error = 0;

if (!empty($_GET['help']))
{
	$tested = false;

	$type = strtolower($_GET['help']);
	$help = array();
	$help['php'] = 'Your PHP Version is too low to support vBulletin 5, you must at least upgrade to 5.4.0.';
	$help['mysql'] = 'Your MySQL version is too low to support vBulletin 5, you must at least upgrade to 5.1.15.';
	$help['pcre'] = 'vBulletin requires PCRE to be enabled in PHP, ask your host to enable this in php.ini';
	$help['open_basedir'] = 'You may experience problems with uploading files to vBulletin';
	$help['curl'] = 'The cUrl extension is needed for many features that gather data from the internet';
	$help['json'] = 'The JSON extension is required to support vBulletin 5';
	$help['gzip'] = 'vBulletin uses GZIP to compress pages, though this is not essential for operation';
	$help['mysql_perms'] = 'vBulletin requires that the mysql username has create, select, update, insert, delete, alter and drop privledges, contact your host and ask them to adjust these privledges.';
	$help['xml'] = 'XML is required as a major component of vBulletin for data storage of languages, settings and templates.';
	$help['gd'] = 'GD functions are used to produce images, this includes features such as thumbnails and image verification on registration';
	$help['pcre.backtrack_limit'] = 'PHP 5.2.0 imposes a limit on PCRE code that we are unable to work-around on this server. Ask your host to add the following to php.ini:<br /><code>pcre.backtrack_limit = -1</code>';

	echo '<tr><td class="tcat" colspan="3" align="center"><b>' . htmlspecialchars($type) . ' Help</b></td></tr>';
	echo '<tr valign="top" align="left" class="alt1"><td>' . $help["$type"] . '</td></tr>';
}
elseif (empty($_POST['server']) or empty($_POST['user']) or empty($_POST['db']))
{
	$tested = false;

	echo '<tr><td class="tcat" colspan="3" align="center"><b>MySQL Information</b></td></tr>';
	echo '<form method="post">';
	echo '<tr valign="top" align="center" class="alt1">';
	echo '	<td align="left">MySQL Server</td>';
	echo '	<td align="left"><input type="text" name="server" value="localhost" /></td>';
	echo '</tr>';
	echo '<tr valign="top" align="center" class="alt2">';
	echo '	<td align="left">MySQL Database</td>';
	echo '	<td align="left"><input type="text" name="db" /></td>';
	echo '</tr>';
	echo '<tr valign="top" align="center" class="alt1">';
	echo '	<td align="left">MySQL Username</td>';
	echo '	<td align="left"><input type="text" name="user" /></td>';
	echo '</tr>';
	echo '<tr valign="top" align="center" class="alt2">';
	echo '	<td align="left">MySQL Password</td>';
	echo '	<td align="left"><input type="password" name="pass" autocomplete="off" /></td>';
	echo '</tr>';
	echo '<tr valign="top align="center">';
	echo '<td class="submitrow" colspan="2" align="center"><input type="submit" value="Run Test" accesskey="s" /></td>';
	echo '</tr>';
	echo '</form>';
}
else
{
	$tested = true;

	//PHP
	$version['PHP'] = phpversion();
	if (version_compare($version['PHP'], '5.4.0', '<='))
	{
		$e_test['PHP'] = 0;
		$e_error++;
	}
	else
	{
		$e_test['PHP'] = 1;
	}

	$db = DB::fetch_db((function_exists('mysqli_connect') ? 'mysqli' : 'mysql'), $_POST['server'], $_POST['user'], $_POST['pass'], $_POST['db']);
	//MySQL
	if(!$db)
	{
		$e_test['MySQL'] = 0;
		$e_error++;
	}
	else
	{
		$vquery = $db->query('SELECT VERSION() AS version');
		$mysql = $vquery->fetch_array();

		$version['MySQL'] = $mysql['version'];
		if (version_compare($version['MySQL'], '5.1.15', '<='))
		{
			$e_test['MySQL'] = 0;
			$e_error++;
		}
		else
		{
			$e_test['MySQL'] = 1;
		}
	}

	$mysql = array();

	//Now all those MySQL Permissions: Create, Drop, Alter, Select, Update, Delete
	$query = 'CREATE TABLE vb3_test (
		test int(10) unsigned NOT NULL
		)';
	if (!$db OR !$db->query($query))
	{
		$mysql['create'] = 0;
		$e_error++;
	}
	else
	{
		$mysql['create'] = 1;
	}

	if (!$db OR !$db->query('ALTER TABLE vb3_test CHANGE test test VARCHAR(254) NOT NULL'))
	{
		$mysql['alter'] = 0;
		$e_error++;
	}
	else
	{
		$mysql['alter'] = 1;
	}


	if (!$db OR !$db->query('INSERT INTO vb3_test (test) VALUES (\'abcd\')'))
	{
		$mysql['insert'] = 0;
		$e_error++;
	}
	else
	{
		$mysql['insert'] = 1;
	}

	if (!$db OR !$db->query('UPDATE vb3_test SET test=123 WHERE test=\'abcd\''))
	{
		$mysql['update'] = 0;
		$e_error++;
	}
	else
	{
		$mysql['update'] = 1;
	}

	if (!$db OR !$db->query('SELECT * FROM vb3_test WHERE test=123'))
	{
		$mysql['select'] = 0;
		$e_error++;
	}
	else
	{
		$mysql['select'] = 1;
	}

	if (!$db OR !$db->query('DELETE FROM vb3_test WHERE test=123'))
	{
		$mysql['delete'] = 0;
		$e_error++;
	}
	else
	{
		$mysql['delete'] = 1;
	}

	if (!$db OR !$db->query('DROP TABLE vb3_test'))
	{
		$mysql['drop'] = 0;
		$e_error++;
	}
	else
	{
		$mysql['drop'] = 1;
	}

	if ($db)
	{
		$db->close();
	}

	$essential_modules = array(
		'PCRE' => 'preg_replace',
		'XML' => 'xml_set_element_handler',
		'curl' => 'curl_init',
		'json' => 'json_encode'
	);

	$recommended_modules = array(
		'GZIP' => array('crc32', 'gzcompress'),
		'GD' => 'imagecreatetruecolor'
	);

	foreach ($essential_modules AS $module => $function)
	{
		$test_function = $function;
		if (!is_array($function))
		{
			$test_function = array($test_function);
		}

		$pass = true;
		foreach($test_function AS $check)
		{
			if (!function_exists($check))
			{
				$pass = false;
			}
		}

		if ($pass)
		{
			$e_test[$module] = 1;
		}
		else
		{
			$e_test[$module] = 0;
			$e_error++;
		}
	}

	foreach ($recommended_modules AS $module => $function)
	{
		$test_function = $function;
		if (!is_array($function))
		{
			$test_function = array($test_function);
		}

		$pass = true;
		foreach($test_function AS $check)
		{
			if (!function_exists($check))
			{
				$pass = false;
			}
		}

		if ($pass)
		{
			$test[$module] = 1;
		}
		else
		{
			$test[$module] = 0;
			$error++;
		}
	}

	//not sure why we ste the version only if GD passes.
	if ($test['GD'])
	{
		$version['GD'] = '2.x';
	}

	//Open Base Dir check
	if (get_cfg_var('open_basedir') == '')
	{
		$test['open_basedir'] = 1;
	}
	else
	{
		$test['open_basedir'] = 0;
		$error++;
	}



	//PCRE BACKTRACK
	if (version_compare($version['PHP'], '5.2.0', '>=') AND test_ini_set('pcre.backtrack_limit', -1) === false)
	{
		$test['pcre.backtrack_limit'] = 0;
		$error++;
	}
	else
	{
		$test['pcre.backtrack_limit'] = 1;
	}

	echo '<tr><td class="tcat" colspan="3" align="center"><b>Essential vBulletin Requirements</b></td></tr>';
	foreach ($e_test AS $type => $result) {
		echo '<tr valign="top" align="center" class="alt1">';
		echo '	<td align="left">' . $type . '</td>';
		echo '	<td align="left">' . (!isset($version["$type"]) ? '' : $version["$type"]) . '</td>';
		echo '	<td align="left">' . iif($result, 'Pass', '<b><a href="vb_test.php?help=' . $type . '">Fail</a></b>') . '</td>';
		echo '</tr>';
	}
	if ($db_connection_error)
	{
		echo '<tr valign="top" align="center" class="alt1">';
		echo '	<td align="left" colspan="3"><strong>Database Connection Error</strong>:&nbsp;&nbsp;' . $db_connection_error . '</td>';
		echo '</tr>';
	}
	echo '<tr><td class="tcat" colspan="3" align="center"><b>MySQL Permission Requirements</b></td></tr>';
	foreach ($mysql AS $type => $result) {
		echo '<tr valign="top" align="center" class="alt2">';
		echo '	<td align="left" colspan="2">' . $type . '</td>';
		echo '	<td align="left">' . iif($result, 'Pass', '<b><a href="vb_test.php?help=mysql_perms">Fail</a></b>') . '</td>';
		echo '</tr>';
	}

	echo '<tr><td class="tcat" colspan="3" align="center"><b>Recommended Settings</b> (<em>Optional</em>)</td></tr>';
	foreach ($test AS $type => $result) {
		echo '<tr valign="top" align="center" class="alt1">';
		echo '	<td align="left">' . $type . '</td>';
		echo '	<td align="left">' . (!isset($version["$type"]) ? '' : $version["$type"]) . '</td>';
		echo '	<td align="left">' . iif($result, 'Pass', '<b><a href="vb_test.php?help=' . $type . '">Fail</a></b>') . '</td>';
		echo '</tr>';
	}

	echo '<tr><td class="tcat" colspan="2" align="center">Overall Result:</td><td class="tcat"><b>' . iif($e_error, 'Fail', 'Pass') . '</b></td></tr>';

}

?>
</table>
</td></tr></table>
<?php
	if ($tested AND is_array($test) AND is_array($e_test))
	{
		if ($e_error == 0 AND $error == 0)
		{
			echo '<p style="text-align: center">vBulletin 5 should run on your system without any errors</p>';
		}
		elseif ($e_error == 0)
		{
			echo '<p style="text-align: center">vBulletin 5 should run on your system though there may be reduced functionality, click the link(s) above for more information</p>';
		}
		else
		{
			echo '<p style="text-align: center">vBulletin5  will not run on your system, please click the link(s) above for more information.</p>';
		}
	}
/*======================================================================*\
|| ####################################################################
|| # CVS: $RCSfile$ - $Revision: 16331 $
|| ####################################################################
\*======================================================================*/
?>
</body>
</html>
